#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 Mirror, VROM_use;
	u8 CHR_L, CHR_H;
	u8 PRG, CHR[4];
}	Mapper;

static	void	Sync (void)
{
	u8 x;
	MP->SetPRG_ROM16(0x8,Mapper.PRG);
	MP->SetPRG_ROM16(0xC,-1);
	for (x = 0; x < 4; x++)
		MP->SetCHR_ROM2(x << 1,Mapper.CHR[x]);
}

static	void	SyncNametables (void)
{
	if (Mapper.VROM_use)
	{
		u8 A,B,C,D;
		switch (Mapper.Mirror)
		{
		case 0:	A = C = Mapper.CHR_L;
			B = D = Mapper.CHR_H;		break;
		case 1:	A = B = Mapper.CHR_L;
			C = D = Mapper.CHR_H;		break;
		case 2:	A = B = C = D = Mapper.CHR_L;	break;
		case 3:	A = B = C = D = Mapper.CHR_H;	break;
		}
		MP->SetCHR_ROM1(0x8,A | 0x80);
		MP->SetCHR_ROM1(0x9,B | 0x80);
		MP->SetCHR_ROM1(0xA,C | 0x80);
		MP->SetCHR_ROM1(0xB,D | 0x80);
	}
	else
	{
		switch (Mapper.Mirror & 0x3)
		{
		case 0:	MP->Mirror_V();		break;
		case 1:	MP->Mirror_H();		break;
		case 2:	MP->Mirror_S0();	break;
		case 3:	MP->Mirror_S1();	break;
		}
	}
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
			MI[x++] = Mapper.Mirror;
			MI[x++] = Mapper.VROM_use;
			MI[x++] = Mapper.CHR_L;
			MI[x++] = Mapper.CHR_H;
			MI[x++] = Mapper.PRG;
for (i = 0; i < 4; i++)	MI[x++] = Mapper.CHR[i];
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
			Mapper.Mirror	= MI[x++];
			Mapper.VROM_use	= MI[x++];
			Mapper.CHR_L	= MI[x++];
			Mapper.CHR_H	= MI[x++];
			Mapper.PRG	= MI[x++];
for (i = 0; i < 4; i++)	Mapper.CHR[i]	= MI[x++];
	Sync();
	SyncNametables();
}

static	void	__cdecl	Write8 (int Bank, int Where, int What)
{
	Mapper.CHR[0] = What;
	Sync();
}

static	void	__cdecl	Write9 (int Bank, int Where, int What)
{
	Mapper.CHR[1] = What;
	Sync();
}

static	void	__cdecl	WriteA (int Bank, int Where, int What)
{
	Mapper.CHR[2] = What;
	Sync();
}

static	void	__cdecl	WriteB (int Bank, int Where, int What)
{
	Mapper.CHR[3] = What;
	Sync();
}

static	void	__cdecl	WriteC (int Bank, int Where, int What)
{
	if (Mapper.CHR_L == What)
		return;
	Mapper.CHR_L = What;
	SyncNametables();
}

static	void	__cdecl	WriteD (int Bank, int Where, int What)
{
	if (Mapper.CHR_H == What)
		return;
	Mapper.CHR_H = What;
	SyncNametables();
}

static	void	__cdecl	WriteE (int Bank, int Where, int What)
{
	if ((Mapper.Mirror == (What & 0x03)) && ((What & 0x10) == Mapper.VROM_use))
		return;
	Mapper.Mirror = What & 0x3;
	Mapper.VROM_use = (What & 0x10);
	SyncNametables();
}

static	void	__cdecl	WriteF (int Bank, int Where, int What)
{
	Mapper.PRG = What;
	Sync();
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;
	iNES_InitROM();

	MP->SetWriteHandler(0x8,Write8);
	MP->SetWriteHandler(0x9,Write9);
	MP->SetWriteHandler(0xA,WriteA);
	MP->SetWriteHandler(0xB,WriteB);
	MP->SetWriteHandler(0xC,WriteC);
	MP->SetWriteHandler(0xD,WriteD);
	MP->SetWriteHandler(0xE,WriteE);
	MP->SetWriteHandler(0xF,WriteF);

	Mapper.PRG = 0;
	for (x = 0; x < 4; x++)	Mapper.CHR[x] = x;
	Mapper.Mirror = Mapper.VROM_use = 0;
	Mapper.CHR_L = Mapper.CHR_H = 0;

	Sync();
	SyncNametables();
}

CTMapperInfo	MapperInfo_068 =
{
	"Sunsoft Mapper #4",
	68,
	MS_Full,
	8192,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};