#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 PRG;
}	Mapper;

static	void	Sync (void)
{
	MP->SetPRG_ROM16(0x8,Mapper.PRG);
	MP->SetPRG_ROM16(0xC,-1);
	MP->SetCHR_RAM8(0,0);
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.PRG;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.PRG		= MI[x++];
	Sync();
}

static	void	__cdecl	Write67CDEF (int Bank, int Where, int What)
{
	Mapper.PRG = What;
	Sync();
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	iNES_InitROM();

	MP->SetWriteHandler(0x6,Write67CDEF);
	MP->SetWriteHandler(0x7,Write67CDEF);
	MP->SetWriteHandler(0xC,Write67CDEF);
	MP->SetWriteHandler(0xD,Write67CDEF);
	MP->SetWriteHandler(0xE,Write67CDEF);
	MP->SetWriteHandler(0xF,Write67CDEF);

	Mapper.PRG = 0;
	Sync();
}

CTMapperInfo	MapperInfo_071 =
{
	"Camerica (partial)",
	71,
	MS_Partial,
	16384,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};