#include	"..\DLL\d_iNES.h"

static	struct
{
	PWriteFunc Write;
	u8 CHR;
}	Mapper;

static	void	Sync (void)
{
	MP->SetPRG_RAM8(0x6,0);
	MP->SetPRG_ROM32(0x8,0);
	MP->SetCHR_ROM8(0,Mapper.CHR);
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.CHR;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.CHR = MI[x++];
}

static	void	__cdecl	Write (int Bank,int Where,int What)
{
	if (Where == 0x016)
	{
		Mapper.CHR = (What & 0x04) >> 2;
		Sync();
	}
	Mapper.Write(Bank,Where,What);
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	Mapper.Write = MP->GetWriteHandler(0x4);
	MP->SetWriteHandler(0x4,Write);
	Mapper.CHR = 0;
	Sync();
	iNES_InitROM();
}

CTMapperInfo	MapperInfo_099 =
{
	"VS Unisystem",
	99,
	MS_Full,
	32768,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};