#include	"..\DLL\d_iNES.h"
#include	"resource.h"

static char BankNum[16];

LRESULT CALLBACK DLG_BankNum(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
			SetFocus(GetDlgItem(hDlg,IDC_BANKNUM));
			return FALSE;
		case WM_COMMAND:
			switch (LOWORD(wParam))
			{
			case IDOK:
				GetDlgItemText(hDlg,IDC_BANKNUM,BankNum,16);
				if (BankNum[0])
				{
					EndDialog(hDlg,1);
					return TRUE;	break;
				}
			case IDCANCEL:	// else fall through
				EndDialog(hDlg,-1);
				return TRUE;		break;
			}
			break;
		case WM_CLOSE:
			EndDialog(hDlg,-1);
			return TRUE;		break;
	}
	return FALSE;
}

#define	DB_SETPROM	0
#define	DB_SETPRAM	1
#define	DB_SETCROM	2
#define	DB_SETCRAM	3

#include <stdlib.h>

static	void	__cdecl	MenuClick (int Command, int Parm1, int Parm2, int Parm3)
{
	int Bank;
	if ((Command < 0) || (Command > 3))	return;
	DialogBox(hInstance,MAKEINTRESOURCE(IDD_PROMPTBANK),GetActiveWindow(),(DLGPROC)DLG_BankNum);
	Bank = atoi(BankNum);
	switch (Command)
	{
	case DB_SETPROM:
		switch(Parm1)
		{
		case 8:	MP->SetPRG_ROM8(Parm2,Bank);	break;
		case 16:MP->SetPRG_ROM16(Parm2,Bank);	break;
		case 32:MP->SetPRG_ROM32(Parm2,Bank);	break;
		}	break;
	case DB_SETPRAM:
		switch(Parm1)
		{
		case 8:	MP->SetPRG_ROM8(Parm2,Bank);	break;
		case 16:MP->SetPRG_ROM16(Parm2,Bank);	break;
		}	break;
	case DB_SETCROM:
		switch(Parm1)
		{
		case 1:	MP->SetCHR_ROM1(Parm2,Bank);	break;
		case 2:	MP->SetCHR_ROM2(Parm2,Bank);	break;
		case 4:	MP->SetCHR_ROM4(Parm2,Bank);	break;
		case 8:	MP->SetCHR_ROM8(Parm2,Bank);	break;
		}	break;
	case DB_SETCRAM:
		switch(Parm1)
		{
		case 1:	MP->SetCHR_RAM1(Parm2,Bank);	break;
		case 2:	MP->SetCHR_RAM2(Parm2,Bank);	break;
		case 4:	MP->SetCHR_RAM4(Parm2,Bank);	break;
		case 8:	MP->SetCHR_RAM8(Parm2,Bank);	break;
		}	break;
	}
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	int rootmenu, submenu;
	MP = _MP;
	iNES_InitROM();
	MP->SetPRG_ROM32(0x8,-1);
	MP->SetCHR_RAM8(0,0);

	rootmenu = MP->GetMenuRoot();

	submenu = MP->AddMenuItem(rootmenu,"PROM 8",-1,-1,-1,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"$8000",DB_SETPROM,8,0x8,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"$A000",DB_SETPROM,8,0xA,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"$C000",DB_SETPROM,8,0xC,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"$E000",DB_SETPROM,8,0xE,-1,MENU_NOCHECK);
	submenu = MP->AddMenuItem(rootmenu,"PROM 16",-1,-1,-1,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"$8000",DB_SETPROM,16,0x8,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"$C000",DB_SETPROM,16,0xC,-1,MENU_NOCHECK);
	submenu = MP->AddMenuItem(rootmenu,"PROM 32",-1,-1,-1,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"$8000",DB_SETPROM,32,0x8,-1,MENU_NOCHECK);

	submenu = MP->AddMenuItem(rootmenu,"PRAM 8",-1,-1,-1,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"$8000",DB_SETPRAM,8,0x8,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"$A000",DB_SETPRAM,8,0xA,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"$C000",DB_SETPRAM,8,0xC,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"$E000",DB_SETPRAM,8,0xE,-1,MENU_NOCHECK);
	submenu = MP->AddMenuItem(rootmenu,"PRAM 16",-1,-1,-1,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"$8000",DB_SETPRAM,16,0x8,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"$C000",DB_SETPRAM,16,0xC,-1,MENU_NOCHECK);

	submenu = MP->AddMenuItem(rootmenu,"CROM 1",-1,-1,-1,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"0",DB_SETCROM,1,0,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"1",DB_SETCROM,1,1,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"2",DB_SETCROM,1,2,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"3",DB_SETCROM,1,3,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"4",DB_SETCROM,1,4,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"5",DB_SETCROM,1,5,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"6",DB_SETCROM,1,6,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"7",DB_SETCROM,1,7,-1,MENU_NOCHECK);
	submenu = MP->AddMenuItem(rootmenu,"CROM 2",-1,-1,-1,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"0",DB_SETCROM,2,0,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"2",DB_SETCROM,2,2,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"4",DB_SETCROM,2,4,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"6",DB_SETCROM,2,6,-1,MENU_NOCHECK);
	submenu = MP->AddMenuItem(rootmenu,"CROM 4",-1,-1,-1,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"0",DB_SETCROM,4,0,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"4",DB_SETCROM,4,4,-1,MENU_NOCHECK);
	submenu = MP->AddMenuItem(rootmenu,"CROM 8",-1,-1,-1,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"0",DB_SETCROM,8,0,-1,MENU_NOCHECK);

	submenu = MP->AddMenuItem(rootmenu,"CRAM 1",-1,-1,-1,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"0",DB_SETCRAM,1,0,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"1",DB_SETCRAM,1,1,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"2",DB_SETCRAM,1,2,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"3",DB_SETCRAM,1,3,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"4",DB_SETCRAM,1,4,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"5",DB_SETCRAM,1,5,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"6",DB_SETCRAM,1,6,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"7",DB_SETCRAM,1,7,-1,MENU_NOCHECK);
	submenu = MP->AddMenuItem(rootmenu,"CRAM 2",-1,-1,-1,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"0",DB_SETCRAM,2,0,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"2",DB_SETCRAM,2,2,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"4",DB_SETCRAM,2,4,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"6",DB_SETCRAM,2,6,-1,MENU_NOCHECK);
	submenu = MP->AddMenuItem(rootmenu,"CRAM 4",-1,-1,-1,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"0",DB_SETCRAM,4,0,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"4",DB_SETCRAM,4,4,-1,MENU_NOCHECK);
	submenu = MP->AddMenuItem(rootmenu,"CRAM 8",-1,-1,-1,-1,MENU_NOCHECK);
	MP->AddMenuItem(submenu,"0",DB_SETCRAM,8,0,-1,MENU_NOCHECK);
}

CTMapperInfo	MapperInfo_100 =
{
	"Debugging Mapper",
	100,
	MS_Full,
	32768,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	MenuClick
};
