#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 Cmd, CHR0l, CHR1l, CHR0h, CHR1h, CHRch, PRG, CHRmode, Mirror;
	PWriteFunc Write4;
}	Mapper;

static	void	Sync (void)
{
	MP->SetPRG_ROM32(0x8,Mapper.PRG);
	MP->SetCHR_RAM8(0,0);
	MP->SetCHR_ROM2(0,0 | (Mapper.CHR0l << 1) | (Mapper.CHRch << 4));
	MP->SetCHR_ROM2(2,1 | (Mapper.CHR0h << 1) | (Mapper.CHRch << 4));
	MP->SetCHR_ROM2(4,0 | (Mapper.CHR1l << 1) | (Mapper.CHRch << 4));
	MP->SetCHR_ROM2(6,1 | (Mapper.CHR1h << 1) | (Mapper.CHRch << 4));
	switch (Mapper.Mirror >> 1)
	{
	case 0:	MP->Mirror_Custom(0,0,0,1);	break;
	case 1:	MP->Mirror_H();			break;
	case 2:	MP->Mirror_V();			break;
	case 3:	MP->Mirror_S0();		break;
	}
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.Cmd;
	MI[x++] = Mapper.CHR0l;
	MI[x++] = Mapper.CHR0h;
	MI[x++] = Mapper.CHR1l;
	MI[x++] = Mapper.CHR1h;
	MI[x++] = Mapper.CHRch;
	MI[x++] = Mapper.PRG;
	MI[x++] = Mapper.CHRmode;
	MI[x++] = Mapper.Mirror;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.Cmd	= MI[x++];
	Mapper.CHR0l	= MI[x++];
	Mapper.CHR0h	= MI[x++];
	Mapper.CHR1l	= MI[x++];
	Mapper.CHR1h	= MI[x++];
	Mapper.CHRch	= MI[x++];
	Mapper.PRG	= MI[x++];
	Mapper.CHRmode	= MI[x++];
	Mapper.Mirror	= MI[x++];
	Sync();
}

static	void	__cdecl	Write (int Bank, int Where, int What)
{
	u16 Loc = (Bank << 12) | Where;
	if (Loc < 0x4018)
	{
		Mapper.Write4(Bank,Where,What);
		return;
	}
	What &= 0x07;
	switch (Loc & 0x4101)
	{
	case 0x4100:	Mapper.Cmd = What;	break;
	case 0x4101:	switch (Mapper.Cmd)
			{
			case 0:	Mapper.CHR0l = What;	break;
			case 1:	Mapper.CHR0h = What;	break;
			case 2:	Mapper.CHR1l = What;	break;
			case 3:	Mapper.CHR1h = What;	break;
			case 4:	Mapper.CHRch = What;	break;
			case 5:	Mapper.PRG = What;	break;
			case 6:	Mapper.CHRmode = What;	break;
			case 7:	Mapper.Mirror = What;	break;
			}			break;
	}
	Sync();
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;
	iNES_InitROM();

	Mapper.Write4 = MP->GetWriteHandler(0x4);
	for (x = 0x4; x < 0x8; x++)
		MP->SetWriteHandler(x,Write);

	Mapper.Cmd = Mapper.CHR0l = Mapper.CHR1l = Mapper.CHR0h = Mapper.CHR1h = Mapper.CHRch = Mapper.PRG = Mapper.Mirror = Mapper.CHRmode = 0;

	Sync();
}

CTMapperInfo	MapperInfo_141 =
{
	"Mapper 141 (Sachen)",
	141,
	MS_Partial,
	32768,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};