#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_MMC3.h"

static	void	Sync (void)
{
	MMC3_SyncPRG(0x3F,0);
	MMC3_SyncCHR_ROM(0xFF,0);
	MMC3_SyncMirror();
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	MMC3_SaveMI(MI,0);
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	MMC3_LoadMI(MI,0);
}

static	void	__cdecl	Write89 (int Bank, int Where, int What)
{
	MMC3_WriteAB(Bank,0,What);
}

static	void	__cdecl	WriteAB (int Bank, int Where, int What)
{
	unsigned char LUT[8] = {0,3,1,5,6,7,2,4};
	MMC3_Write89(Bank,0,LUT[What & 0x7]);
}

static	void	__cdecl	WriteCD (int Bank, int Where, int What)
{
	MMC3_Write89(Bank,1,What);
}

static	void	__cdecl	WriteEF (int Bank, int Where, int What)
{
	if (What)
	{
		MMC3_WriteCD(Bank,0,What);
		MMC3_WriteEF(Bank,1,What);
	}
	else	MMC3_WriteEF(Bank,0,What);
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
	MMC3_Destroy();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	iNES_InitROM();

	MP->SetPRG_RAM8(0x6,0);

	MMC3_Init(Sync);

	MP->SetWriteHandler(0x8,Write89);
	MP->SetWriteHandler(0x9,Write89);
	MP->SetWriteHandler(0xA,WriteAB);
	MP->SetWriteHandler(0xB,WriteAB);
	MP->SetWriteHandler(0xC,WriteCD);
	MP->SetWriteHandler(0xD,WriteCD);
	MP->SetWriteHandler(0xE,WriteEF);
	MP->SetWriteHandler(0xF,WriteEF);
}

CTMapperInfo	MapperInfo_182 =
{
	"Super Donkey Kong",
	182,
	MS_Full,
	8192,
	InitMapper,
	UnloadMapper,
	MMC3_HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
