#include	"..\DLL\d_iNES.h"

static	struct
{
	int WhichGame;
	int WhichBank;
}	Mapper;

static	void	Sync (void)
{
	MP->SetPRG_ROM16(0x8,Mapper.WhichGame | Mapper.WhichBank);
	MP->SetPRG_ROM16(0xC,Mapper.WhichGame | 3);
	MP->SetCHR_RAM8(0,0);
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.WhichGame;
	MI[x++] = Mapper.WhichBank;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.WhichGame	= MI[x++];
	Mapper.WhichBank	= MI[x++];
	Sync();
}

static	void	__cdecl	Write9 (int Bank, int Where, int What)
{
	Mapper.WhichGame = (What & 0x18) >> 1;
	Sync();
}

static	void	__cdecl	WriteABCDEF (int Bank, int Where, int What)
{
	Mapper.WhichBank = What & 3;
	Sync();
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;

	iNES_InitROM();

	MP->SetWriteHandler(0x9,Write9);
	MP->SetWriteHandler(0xA,WriteABCDEF);
	MP->SetWriteHandler(0xB,WriteABCDEF);
	MP->SetWriteHandler(0xC,WriteABCDEF);
	MP->SetWriteHandler(0xD,WriteABCDEF);
	MP->SetWriteHandler(0xE,WriteABCDEF);
	MP->SetWriteHandler(0xF,WriteABCDEF);

	Mapper.WhichGame = 0;
	Mapper.WhichBank = 3;

	Sync();
}

CTMapperInfo	MapperInfo_232 =
{
	"Camerica 9096",
	232,
	MS_Nearly,
	16384,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};