#include	"..\DLL\d_iNES.h"

static	struct
{
	PReadFunc Read;
	u8 Reg1, Reg2, Reg3;
}	Mapper;

static	void	Sync (void)
{
	if (Mapper.Reg1 & 0x80)
		MP->Mirror_H();
	else	MP->Mirror_V();
	if (Mapper.Reg1 & 0x40)
	{
		MP->SetPRG_ROM32(0x8,(Mapper.Reg1 & 0x0E) | (Mapper.Reg2 & 0x01));
		MP->SetCHR_ROM8(0,((Mapper.Reg1 & 0x0E) << 2) | ((Mapper.Reg2 & 0x70) >> 4));
	}
	else
	{
		MP->SetPRG_ROM32(0x8,Mapper.Reg1 & 0x0F);
		MP->SetCHR_ROM8(0,((Mapper.Reg1 & 0x0F) << 2) | ((Mapper.Reg2 & 0x30) >> 4));
	}
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.Reg1;
	MI[x++] = Mapper.Reg2;
	MI[x++] = Mapper.Reg3;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.Reg1	= MI[x++];
	Mapper.Reg2	= MI[x++];
	Mapper.Reg3	= MI[x++];
	Sync();
}

static	void	__cdecl	Write (int Bank, int Where, int What)
{
	switch (Where & 0xFF8)
	{
	case 0xF80:
	case 0xF88:
	case 0xF90:
	case 0xF98:	if (Mapper.Reg1)	break;
				Mapper.Reg1 = What;
			Sync();			break;
	case 0xFA0:
	case 0xFA8:
	case 0xFB0:
	case 0xFB8:	break;
	case 0xFC0:
	case 0xFC8:
	case 0xFD0:
	case 0xFD8:	if (Mapper.Reg3)	break;
				Mapper.Reg3 = What;
			Sync();			break;
	case 0xFE0:	break;
	case 0xFE8:
	case 0xFF0:	Mapper.Reg2 = What;
			Sync();			break;
	case 0xFF8:	break;
	}
}

static	int	__cdecl	Read (int Bank, int Where)
{
	int What = Mapper.Read(Bank,Where);
	if ((Where & 0xF80) == 0xF80)
		Write(Bank,Where,What);
	return What;
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	iNES_InitROM();

	Mapper.Read = MP->GetReadHandler(0xF);
	MP->SetReadHandler(0xF,Read);
	MP->SetWriteHandler(0xF,Write);

	Mapper.Reg1 = Mapper.Reg2 = Mapper.Reg3 = 0;
	Sync();
}

CTMapperInfo	MapperInfo_234 =
{
	"Maxi 15",
	234,
	MS_Full,
	32768,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};